'' Code supplement on how to use:
''  1. Loading spritesets made with my texture packer
''  2. loading tilesets with the same tile dimensions

'' Relminator(Richard Eric M. Lope BSN RN)
'' Http://rel.betterwebber.com


''NOTE: You will notice that using spritesets eliminate the need to 
''      cast() the image to FB.IMAGE
 

#include once "fbgl2d.bi"   
#include once "fbgl2d.bas" 

'' include auto_generated texture coords
'' by my texture packer
#include once "uvcoord_crono.bi"

'' A randomized bg
declare sub draw_bg(sprites() as GL2D.image ptr, map() as ubyte)

using FB

const SCR_WIDTH = 640
const SCR_HEIGHT = 480
const as single PI = atn(1)*4

const false = 0
const true = not false


'' our randomized BG map
redim as ubyte map(SCR_WIDTH * SCR_HEIGHT)


'' initialize gl2d (640 x 480)
gl2d.screen_init( SCR_WIDTH, SCR_HEIGHT )

'' crono and tiles
'' redim it to force dynamic memory
redim as GL2D.IMAGE ptr tiles(0)
redim as GL2D.IMAGE ptr crono(0)

'' init spritesheet using my texture packer
gl2d.init_sprites(crono(),crono_texcoords(),"crono.bmp")

'' TRY to REM the above and UNREM this for bi-linear filtering
'' gl2d.init_sprites(crono(),crono_texcoords(),"crono.bmp", GL_LINEAR)

'' init our sprites without the help of the texture packer
'' since we know our tiles are 16 x 16 in size
gl2d.init_sprites(tiles(),16,16,"tiles_128x256_16x16.bmp")


'' init our map with randomized munbers
'' Notice thai I'm using ubound for safety
'' tileset is resized after init_sprites
'' maxtiles = ubound(tiles)
'' I subtracted stuff because we have some dead
'' tiles at the end of the tileset.
'' More reason to use my texture packer
for i as integer = 0 to ubound(map)
	map(i) = i  mod int((ubound(tiles)-38))
next


gl2d.vsync_on()   '' set vsynch on

dim as integer frame = 0
dim as integer char_index = 0  ' crono animation

do
	frame += 1	
	'' clear buffer
	gl2d.clear_screen()
	
	'' draw our bg
	draw_bg(tiles(), map())
	
	'' animate
	if (frame and 7) = 0 then 
		char_index = (char_index + 1) mod 6		'' mod 6 since we have 6 frames of animation
	endif
	
	'' scale it 2x since it's gonna be too small otherwise
	'' normal transparent
	glColor4ub(255, 255, 255, 255)
	gl2d.sprite_scale( 100,150,2, crono(char_index) )
	gl2d.sprite_scale( 150,150,2, crono(6 + char_index) )
	gl2d.sprite_scale( 200,150,2, crono(12+ char_index) )
	
	'' color it red
	glColor4ub(255, 0, 0, 255)
	gl2d.sprite_scale( 300,150,2, crono(char_index) )
	'' pink
	glColor4ub(255, 0, 255, 255)
	gl2d.sprite_scale( 350,150,2, crono(6 + char_index) )
	'' blue
	glColor4ub(0, 0, 255, 255)
	gl2d.sprite_scale( 400,150,2, crono(12+ char_index) )


	'' blend it by 200/255
	gl2d.set_blend_mode(GL2D.E_BLENDED)
	glColor4ub(255, 255, 255, 200)
	gl2d.sprite_scale( 100,250,2, crono(char_index) )
	gl2d.sprite_scale( 150,250,2, crono(6 + char_index) )
	gl2d.sprite_scale( 200,250,2, crono(12+ char_index) )
	
	
	' Enable sprite stencil
	gl2d.set_blend_mode(GL2D.E_TRANS)
	glColor4ub(255, 255, 255, 255)
	gl2d.enable_sprite_stencil(true, GL2D_RGBA(255,255,255,255), GL2D_RGBA(255,255,255,255))
	gl2d.sprite_scale( 300,250,2, crono(char_index) )

	gl2d.enable_sprite_stencil(true, GL2D_RGBA(0,255,0,255), GL2D_RGBA(0,0,255,255))
	gl2d.sprite_scale( 350,250,2, crono(6 + char_index) )
	
	gl2d.enable_sprite_stencil(true, GL2D_RGBA(0,0,0,255), GL2D_RGBA(0,255,255,255))
	gl2d.sprite_scale( 400,250,2, crono(12+ char_index) )
	
	'' disable sprite stencil
	gl2d.enable_sprite_stencil(false)


	
	'' black mode. Useful for shadows
	gl2d.set_blend_mode(GL2D.E_BLACK)
	glColor4ub(255, 255, 255, 255)	'' full black
	
	gl2d.sprite_scale( 100,350,2, crono(char_index) )
	gl2d.sprite_scale( 150,350,2, crono(6 + char_index) )
	
	'' blend it by 1/2
	'' no need to set E_BLENDED since E_BLACK is blended by default
	glColor4ub(255, 255, 255, 128)
	gl2d.sprite_scale( 200,350,2, crono(12+ char_index) )
	
	'' normal color
	glColor4ub(255,255,255,255)
	'' limit fps to 60 frames per second
	dim as single FPS = gl2d.fps_limit(60)	

	'' print
	gl2d.set_blend_mode(GL2D.E_TRANS)   '' transparent
	glColor4ub(0,0,0,255)  '' no transluceny
	gl2d.print_scale(0, 10,2, "Spriteset example      FPS = " + str(fps))
	gl2d.print_scale(0, 30,1.5, "Crono sprite uses the texturepacker UV values.")
	gl2d.print_scale(0, 50,1.5, "BackGround tiles does not.")
	
	'' print debug stuff
	gl2d.print_scale(0, 80,1.5, "MaxBGTiles    = " + str(ubound(tiles)) )
	gl2d.print_scale(0, 100,1.5, "MaxCronoTiles = " + str(ubound(crono)) )
		
    flip
    
    
	sleep 1,1
Loop Until Multikey( FB.SC_ESCAPE ) 




'' destroy tiles
gl2d.destroy_sprites(tiles())
gl2d.destroy_sprites(crono())
gl2d.destroy()


end


sub draw_bg(sprites() as GL2D.image ptr, map() as ubyte)
	
	dim as integer tiles_x = SCR_WIDTH\sprites(0)->width 
	dim as integer tiles_Y = SCR_HEIGHT\sprites(0)->height 
	
	gl2d.set_blend_mode(GL2D.E_TRANS)
	glColor4ub(255,255,255,255)
	
	dim as integer i = 0			
	for y as integer = 0 to tiles_y
		for x as integer = 0 to tiles_x
			i += 1
			gl2d.sprite( x * sprites(map(i))->width,y * sprites(map(i))->height, sprites(map(i)) )
		next x
	next y

End Sub
